<?php $page_title="Settings App";
    include("includes/header.php");
    require("includes/lb_helper.php");
    require("language/language.php");
    
    if(!isset($_SESSION['admin_type'])){
        if($_SESSION['admin_type'] == 0){
            session_destroy();
            header( "Location:index.php");
            exit;
        }
    }
    
    $privacy_policy_file_path = getBaseUrl().'privacy_policy.php';
    $terms_file_path = getBaseUrl().'terms.php';
    
    $qry="SELECT * FROM tbl_settings where id='1'";
    $result=mysqli_query($mysqli,$qry);
    $settings_data=mysqli_fetch_assoc($result);
    
    if(isset($_POST['submit_general'])){
        
        $data = array(
            'app_email'  =>  $_POST['app_email'],
            'app_author'  =>  $_POST['app_author'],
            'app_contact'  =>  $_POST['app_contact'],
            'app_website'  =>  $_POST['app_website'],
            'app_developed_by'  =>  $_POST['app_developed_by'],
            'app_description'  =>  addslashes($_POST['app_description'])
        );
        
        $settings_edit=Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg']="11";
        $_SESSION['class'] = "success";
        header( "Location:settings_app.php");
        exit;
        
    } else if(isset($_POST['app_submit'])){
        
        $data = array(
            'isRTL'  =>  ($_POST['isRTL']) ? 'true' : 'false',
            'isMaintenance'  =>  ($_POST['isMaintenance']) ? 'true' : 'false',
            'isScreenshot'  =>  ($_POST['isScreenshot']) ? 'true' : 'false',
            
            'isLogin'  =>  ($_POST['isLogin']) ? 'true' : 'false',
            'isGoogleLogin'  =>  ($_POST['isGoogleLogin']) ? 'true' : 'false',
            
            'isAPK'  =>  ($_POST['isAPK']) ? 'true' : 'false',
            'isVPN'  =>  ($_POST['isVPN']) ? 'true' : 'false'
        );
        
        $settings_edit = Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg'] = "11";
        $_SESSION['class'] = "success";
        header("Location:settings_app.php");
        exit;
        
    } else if (isset($_POST['api_submit'])) {
      
        $data = array(
            'home_limit'  =>  $_POST['home_limit'],
            'api_latest_limit'  =>  $_POST['api_latest_limit'],
            'api_cat_order_by'  =>  $_POST['api_cat_order_by'],
            'api_cat_post_order_by'  =>  $_POST['api_cat_post_order_by']
        );
        
        $settings_edit = Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg'] = "11";
        $_SESSION['class'] = "success";
        header("Location:settings_app.php");
        exit;
        
    } else if(isset($_POST['policy_submit'])){
        
        $data = array('app_privacy_policy'  =>  addslashes($_POST['app_privacy_policy']));
        $settings_edit=Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg']="11";
        $_SESSION['class'] = "success";
        header( "Location:settings_app.php");
        exit;
        
    } else if(isset($_POST['terms_submit'])){
        
        $data = array('app_terms'  =>  addslashes($_POST['app_terms']));
        $settings_edit=Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg']="11";
        $_SESSION['class'] = "success";
        header( "Location:settings_app.php");
        exit;
        
    } else if(isset($_POST['notification_submit'])) {
        
        $data = array(
          'onesignal_app_id' => trim($_POST['onesignal_app_id']),
          'onesignal_rest_key' => trim($_POST['onesignal_rest_key']),
        );
        
        $settings_edit = Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg'] = "11";
        $_SESSION['class'] = "success";
        header("Location:settings_app.php");
        exit;
        
    } else if(isset($_POST['app_update_submit'])){
        
        $data = array(
            'app_update_status'  =>  ($_POST['app_update_status']) ? 'true' : 'false',
            'app_new_version'  =>  trim($_POST['app_new_version']),
            'app_update_desc'  =>  trim($_POST['app_update_desc']),
            'app_redirect_url'  =>  trim($_POST['app_redirect_url'])
        );
        
        $settings_edit = Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg']="11";
        $_SESSION['class']='success'; 
        header("Location:settings_app.php");
        exit;
        
    } else if(isset($_POST['ads_submit'])){
        
        $data = array(
            'ad_network'  =>  cleanInput($_POST['ad_network']),
            'publisher_id'  =>  $_POST['publisher_id'],
            'start_ads_id'  =>  $_POST['start_ads_id'],
            'unity_ads_id'  =>  $_POST['unity_ads_id'],
            'iron_ads_id'  =>  $_POST['iron_ads_id'],
            'wortise_app_id'  =>  $_POST['wortise_app_id'],
            
            'banner_ad'  =>  ($_POST['banner_ad']) ? 'true' : 'false',
            'banner_ad_id'  =>  $_POST['banner_ad_id'],
            'banner_facebook_id'  =>  $_POST['banner_facebook_id'],
            'banner_applovins_id'  =>  $_POST['banner_applovins_id'],
            'banner_wortise_id'  =>  $_POST['banner_wortise_id'],
            
            'interstital_ad'  =>  ($_POST['interstital_ad']) ? 'true' : 'false',
            'interstital_ad_id'  =>  $_POST['interstital_ad_id'],
            'interstital_facebook_id'  =>  $_POST['interstital_facebook_id'],
            'interstital_applovins_id'  =>  $_POST['interstital_applovins_id'],
            'interstital_wortise_id'  =>  $_POST['interstital_wortise_id'],
            'interstital_ad_click'  =>  $_POST['interstital_ad_click'],
            
            'native_ad'  =>  ($_POST['native_ad']) ? 'true' : 'false',
            'native_ad_id'  =>  $_POST['native_ad_id'],
            'native_facebook_id'  =>  $_POST['native_facebook_id'],
            'native_applovins_id'  =>  $_POST['native_applovins_id'],
            'native_wortise_id'  =>  $_POST['native_wortise_id'],
            'native_position'  =>  $_POST['native_position']
        );
        
        $settings_edit=Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg']="11";
        $_SESSION['class']='success'; 
        header( "Location:settings_app.php");
        exit;
    } else if(isset($_POST['custom_submit'])){
        
        $data = array(
            'custom_ads'  =>  ($_POST['custom_ads']) ? 'true' : 'false',
            'custom_ads_img'  =>  $_POST['custom_ads_img'],
            'custom_ads_link'  =>  $_POST['custom_ads_link'],
            'custom_ads_clicks'  =>  $_POST['custom_ads_clicks']
        );
        
        $settings_edit=Update('tbl_settings', $data, "WHERE id = '1'");
        
        $_SESSION['msg']="11";
        $_SESSION['class']='success'; 
        header( "Location:settings_app.php");
        exit;
    }
?>

<!-- Start: main -->
<main id="nsofts_main">
    <div class="nsofts-container">
        <nav aria-label="breadcrumb">
            <ol class="breadcrumb align-items-center">
                <li class="breadcrumb-item d-inline-flex"><a href="dashboard.php"><i class="ri-home-4-fill"></i></a></li>
                <li class="breadcrumb-item d-inline-flex active" aria-current="page"><?php echo (isset($page_title)) ? $page_title : "" ?></li>
            </ol>
        </nav>
            
        <div class="card">
            <div class="card-body p-0">                    
                <div class="nsofts-setting">
                    <div class="nsofts-setting__sidebar">
                        <a class="d-inline-flex align-items-center text-decoration-none fw-semibold mb-4">
                            <span class="ps-2 lh-1"><?php echo (isset($page_title)) ? $page_title : "" ?></span>
                        </a>
                        <div class="nav flex-column nav-pills" id="nsofts_setting" role="tablist" aria-orientation="vertical">
                            <button class="nav-link active" id="nsofts_setting_1" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_1" type="button" role="tab" aria-controls="nsofts_setting_1" aria-selected="true">
                                <i class="ri-list-settings-line"></i>
                                <span>General</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_2" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_2" type="button" role="tab" aria-controls="nsofts_setting_2" aria-selected="false">
                                <i class="ri-settings-5-line"></i>
                                <span>App Settings</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_3" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_3" type="button" role="tab" aria-controls="nsofts_setting_3" aria-selected="false">
                                <i class="ri-cloud-line"></i>
                                <span>API</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_4" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_4" type="button" role="tab" aria-controls="nsofts_setting_4" aria-selected="false">
                                <i class="ri-survey-line"></i>
                                <span>Privacy Policy</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_5" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_5" type="button" role="tab" aria-controls="nsofts_setting_5" aria-selected="false">
                                <i class="ri-survey-line"></i>
                                <span>Terms & Conditions</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_6" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_6" type="button" role="tab" aria-controls="nsofts_setting_6" aria-selected="false">
                                <i class="ri-notification-3-line"></i>
                                <span>Notification</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_7" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_7" type="button" role="tab" aria-controls="nsofts_setting_7" aria-selected="false">
                                <i class="ri-refresh-line"></i>
                                <span>App Update</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_8" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_8" type="button" role="tab" aria-controls="nsofts_setting_8" aria-selected="false">
                                <i class="ri-advertisement-line"></i>
                                <span>Advertisement</span>
                            </button>
                            
                            <button class="nav-link" id="nsofts_setting_9" data-bs-toggle="pill" data-bs-target="#nsofts_setting_content_9" type="button" role="tab" aria-controls="nsofts_setting_9" aria-selected="false">
                                <i class="ri-advertisement-line"></i>
                                <span>Custom ads</span>
                            </button>
                                
                        </div>
                    </div>
                    <div class="nsofts-setting__content">
                        <div class="tab-content">
                            
                            <!--General Settings-->
                            <div class="tab-pane fade show active" id="nsofts_setting_content_1" role="tabpanel" aria-labelledby="nsofts_setting_1" tabindex="0">
                                <form action="" name="settings_general" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">General Settings</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Email</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="app_email" id="app_email" value="<?php echo $settings_data['app_email']?>" >
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Author</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="app_author" id="app_author" value="<?php echo $settings_data['app_author']?>" >
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Contact</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="app_contact" id="app_contact" value="<?php echo $settings_data['app_contact']?>" >
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Website</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="app_website" id="app_website" value="<?php echo $settings_data['app_website']?>" >
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Developed By</label>
                                        <div class="col-sm-10">
                                            <input type="text" class="form-control" name="app_developed_by" id="app_developed_by" value="<?php echo $settings_data['app_developed_by']?>" >
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Description</label>
                                        <div class="col-sm-10">
                                            <textarea name="app_description" id="app_description" class="form-control" ><?php echo stripslashes($settings_data['app_description']); ?></textarea>
                                        </div>
                                    </div>
                                    <button type="submit" name="submit_general" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--App Settings-->
                            <div class="tab-pane fade" id="nsofts_setting_content_2" role="tabpanel" aria-labelledby="nsofts_setting_2" tabindex="0">
                                <form action="" name="settings_app" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">App Settings</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">RTL</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isRTL" name="isRTL" value="true" class="nsofts-switch__label" <?php if($settings_data['isRTL']=='true'){ echo 'checked'; }?>/>
                                                <label for="isRTL" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">App Maintenance</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isMaintenance" name="isMaintenance" value="true" class="cbx hidden" <?php if($settings_data['isMaintenance']=='true'){ echo 'checked'; }?>/>
                                                <label for="isMaintenance" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Google Login</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isGoogleLogin" name="isGoogleLogin" value="true" class="cbx hidden" <?php if($settings_data['isGoogleLogin']=='true'){ echo 'checked'; }?>/>
                                                <label for="isGoogleLogin" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">First open login</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isLogin" name="isLogin" value="true" class="cbx hidden" <?php if($settings_data['isLogin']=='true'){ echo 'checked'; }?>/>
                                                <label for="isLogin" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Sccrenshot block</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isScreenshot" name="isScreenshot" value="true" class="cbx hidden" <?php if($settings_data['isScreenshot']=='true'){ echo 'checked'; }?>/>
                                                <label for="isScreenshot" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Developer block</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isAPK" name="isAPK" value="true" class="cbx hidden" <?php if($settings_data['isAPK']=='true'){ echo 'checked'; }?>/>
                                                <label for="isAPK" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">VPN block</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="isVPN" name="isVPN" value="true" class="cbx hidden" <?php if($settings_data['isVPN']=='true'){ echo 'checked'; }?>/>
                                                <label for="isVPN" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" name="app_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--API-->
                            <div class="tab-pane fade" id="nsofts_setting_content_3" role="tabpanel" aria-labelledby="nsofts_setting_3" tabindex="0">
                                <form action="" name="settings_api" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">API Settings</h4>
                                    <div class="row mb-4">
                                        <div class="col-md-6">
                                            <div class="mb-3 row">
                                                <label for="" class="col-sm-5 col-form-label">Home limit</label>
                                                <div class="col-sm-7">
                                                    <input type="number" name="home_limit" id="home_limit" required="" class="form-control" value="<?php echo $settings_data['home_limit'];?>">
                                                </div>
                                            </div>
                                            <div class="mb-3 row">
                                                <label for="" class="col-sm-5 col-form-label">Latest limit</label>
                                                <div class="col-sm-7">
                                                   <input type="number" name="api_latest_limit" id="api_latest_limit" required="" class="form-control" value="<?php echo $settings_data['api_latest_limit'];?>">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="mb-3 row">
                                                <label for="" class="col-sm-5 col-form-label">Category order</label>
                                                <div class="col-sm-7">
                                                    <select name="api_cat_order_by" id="api_cat_order_by" class="form-control" required>
                                                    <option value="cid" <?php if ($settings_data['api_cat_order_by'] == 'cid') { ?>selected<?php } ?>>ID</option>
                                                    <option value="category_name" <?php if ($settings_data['api_cat_order_by'] == 'category_name') { ?>selected<?php } ?>>Name</option>
                                                </select>
                                                </div>
                                            </div>
                                            <div class="mb-3 row">
                                                <label for="" class="col-sm-5 col-form-label">Category post order</label>
                                                <div class="col-sm-7">
                                                    <select name="api_cat_post_order_by" id="api_cat_post_order_by" class="form-control" required>
                                                        <option value="ASC" <?php if ($settings_data['api_cat_post_order_by'] == 'ASC') { ?>selected<?php } ?>>ASC</option>
                                                        <option value="DESC" <?php if ($settings_data['api_cat_post_order_by'] == 'DESC') { ?>selected<?php } ?>>DESC</option>						 
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <button type="submit" name="api_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Privacy Policy-->
                            <div class="tab-pane fade" id="nsofts_setting_content_4" role="tabpanel" aria-labelledby="nsofts_setting_4" tabindex="0">
                                <form action="" name="settings_policy" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">Privacy Policy</h4>
                                    <div class="pb-clipboard mb-2">
                                        <span class="pb-clipboard__url"><span id="clipboard_policy"><?=$privacy_policy_file_path ?></span></span>
                                        <a class="pb-clipboard__link btn_policy" href="javascript:void(0);" data-clipboard-action="copy" data-clipboard-target="#clipboard_base_url" data-bs-toggle="tooltip" data-bs-placement="top" title="Copy">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1" />
                                            </svg>
                                        </a>
                                    </div>
                                    <div>
                                        <textarea name="app_privacy_policy" id="app_privacy_policy" rows="5" class="nsofts-editor mb-4">
                                            <?php echo stripslashes($settings_data['app_privacy_policy']); ?>
                                            
                                        </textarea>
                                    </div>
                                    <button type="submit" name="policy_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Terms & Conditions-->
                            <div class="tab-pane fade" id="nsofts_setting_content_5" role="tabpanel" aria-labelledby="nsofts_setting_5" tabindex="0">
                                <form action="" name="settings_terms" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">Terms & Conditions</h4>
                                    <div class="pb-clipboard mb-2">
                                        <span class="pb-clipboard__url"><span id="clipboard_terms"><?=$terms_file_path ?></span></span>
                                        <a class="pb-clipboard__link btn_terms" href="javascript:void(0);" data-clipboard-action="copy" data-clipboard-target="#clipboard_base_url" data-bs-toggle="tooltip" data-bs-placement="top" title="Copy">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                                <rect x="9" y="9" width="13" height="13" rx="2" ry="2"></rect><path d="M5 15H4a2 2 0 0 1-2-2V4a2 2 0 0 1 2-2h9a2 2 0 0 1 2 2v1" />
                                            </svg>
                                        </a>
                                    </div>
                                    <div>
                                        <textarea name="app_terms" id="app_terms" rows="5" class="nsofts-editor mb-4">
                                           <?php echo stripslashes($settings_data['app_terms']); ?>
                                        </textarea>
                                    </div>
                                    <button type="submit" name="terms_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Notification-->
                            <div class="tab-pane fade" id="nsofts_setting_content_6" role="tabpanel" aria-labelledby="nsofts_setting_6" tabindex="0">
                                <form action="" name="settings_notification" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">Notification</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">OneSignal App ID</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="onesignal_app_id" id="onesignal_app_id" value="<?php echo $settings_data['onesignal_app_id']; ?>"  class="form-control">
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">OneSignal Rest Key</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="onesignal_rest_key" id="onesignal_rest_key" value="<?php echo $settings_data['onesignal_rest_key']; ?>"   class="form-control">
                                        </div>
                                    </div>
                                    <button type="submit" name="notification_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--App Update-->
                            <div class="tab-pane fade" id="nsofts_setting_content_7" role="tabpanel" aria-labelledby="nsofts_setting_7" tabindex="0">
                                <form action="" name="settings_app_update" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">App Update</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">ON/OFF</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="app_update_status" name="app_update_status" value="true" class="nsofts-switch__label" <?php if($settings_data['app_update_status']=='true'){ echo 'checked'; }?>/>
                                                <label for="app_update_status" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">New App Version Code</label>
                                        <div class="col-sm-10">
                                            <input type="number" min="1" name="app_new_version" id="app_new_version" required="" class="form-control" value="<?php echo $settings_data['app_new_version'];?>">
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Description</label>
                                        <div class="col-sm-10">
                                            <textarea name="app_update_desc"  class="form-control"><?php echo stripslashes($settings_data['app_update_desc']); ?></textarea>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">App Link</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="app_redirect_url" id="app_redirect_url" required="" class="form-control" value="<?php echo $settings_data['app_redirect_url'];?>">
                                        </div>
                                    </div>
                                    <button type="submit" name="app_update_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Advertisement-->
                            <div class="tab-pane fade" id="nsofts_setting_content_8" role="tabpanel" aria-labelledby="nsofts_setting_8" tabindex="0">
                                <form action="" name="settings_app" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">Advertisement</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Ad network</label>
                                        <div class="col-sm-10">
                                            <select name="ad_network" id="ad_network" class="form-control" required>
                                                <option value="admob" <?php if ($settings_data['ad_network'] == 'admob') { ?>selected<?php } ?>>AdMob</option>
                                                <option value="facebook" <?php if ($settings_data['ad_network'] == 'facebook') { ?>selected<?php } ?>>Facebook</option>
                                                <option value="startapp" <?php if ($settings_data['ad_network'] == 'startapp') { ?>selected<?php } ?>>StartApp</option>
                                                <option value="iron" <?php if ($settings_data['ad_network'] == 'iron') { ?>selected<?php } ?>>IronSource</option>
                                                <option value="applovins" <?php if ($settings_data['ad_network'] == 'applovins') { ?>selected<?php } ?>>AppLovin's MAX</option>
                                            </select>
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row publisher_id">
                                        <label for="" class="col-sm-2 col-form-label">Publisher ID</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="publisher_id" id="publisher_id" value="<?php echo $settings_data['publisher_id']; ?>" class="form-control">
                                        </div>
                                    </div>
                                    <div class="mb-3 row start_ads_id">
                                        <label for="" class="col-sm-2 col-form-label">StartApp App ID</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="start_ads_id" id="start_ads_id" value="<?php echo $settings_data['start_ads_id']; ?>" class="form-control">
                                        </div>
                                    </div>
 
                                    <div class="mb-3 row iron_ads_id">
                                        <label for="" class="col-sm-2 col-form-label">IronSource ID</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="iron_ads_id" id="iron_ads_id" value="<?php echo $settings_data['iron_ads_id']; ?>" class="form-control">
                                        </div>
                                    </div>
                                    
                                    <div class="mb-3 row wortise_app_id">
                                        <label for="" class="col-sm-2 col-form-label">Wortise App ID</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="wortise_app_id" id="wortise_app_id" value="<?php echo $settings_data['wortise_app_id']; ?>" class="form-control">
                                        </div>
                                    </div>
                                    
                                    <div class="row g-4">
                                        <div class="col-lg-4">
                                            <div class="nsofts-border-card">
                                                <div class="nsofts-border-card__head d-flex align-content-center justify-content-between mb-1">
                                                    <h5 class="mb-0 text-white">Banner Ads</h5>
                                                    <div class="nsofts-switch d-flex align-items-center">
                                                        <input type="checkbox" id="checked1" name="banner_ad" value="true" class="cbx hidden" <?php if($settings_data['banner_ad']=='true'){ echo 'checked'; }?>/>
                                                        <label for="checked1" class="nsofts-switch__label"></label>
                                                    </div>
                                                </div>
                                                <div class="p-3">
                                                    <div class="mb-2">
                                                        <label for="" class="form-label">Banner ID</label>
                                                        
                                                        <h5 class="labels_startapp" style="display: none">For startapp App ID is enough to show banner.</h5>
                                                        <h5 class="labels_iron" style="display: none">For IronSource ID is enough to show banner.</h5>
                                                        
                                                        <div class="banner_ad_id" style="display: none">
                                                            <input type="text" name="banner_ad_id" id="banner_ad_id" value="<?php echo $settings_data['banner_ad_id']; ?>" class="form-control">
                                                        </div>
                                                        <div class="banner_facebook_id" style="display: none">
                                                            <input type="text" name="banner_facebook_id" id="banner_facebook_id" value="<?php echo $settings_data['banner_facebook_id']; ?>" class="form-control">
                                                        </div>
                                                        <div class="banner_applovins_id" style="display: none">
                                                            <input type="text" name="banner_applovins_id" id="banner_applovins_id" value="<?php echo $settings_data['banner_applovins_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <div class="banner_wortise_id" style="display: none">
                                                            <input type="text" name="banner_wortise_id" id="banner_wortise_id" value="<?php echo $settings_data['banner_wortise_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-4">
                                            <div class="nsofts-border-card">
                                                <div class="nsofts-border-card__head d-flex align-content-center justify-content-between mb-1">
                                                    <h5 class="mb-0 text-white">Interstitial Ads</h5>
                                                    <div class="nsofts-switch d-flex align-items-center">
                                                       <input type="checkbox" id="checked2" name="interstital_ad" value="true" class="cbx hidden" <?php if($settings_data['interstital_ad']=='true'){ echo 'checked'; }?>/>
                                                        <label for="checked2" class="nsofts-switch__label"></label>
                                                    </div>
                                                </div>
                                                <div class="p-3">
                                                    <div class="mb-2">
                                                        <p class="labels" >Interstitial Ad ID</p>
                                                        
                                                        <div class="mb-2 interstital_ad_id" style="display: none">
                                                            <input type="text" name="interstital_ad_id" id="interstital_ad_id" value="<?php echo $settings_data['interstital_ad_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <div class="mb-2 interstital_facebook_id" style="display: none">
                                                            <input type="text" name="interstital_facebook_id" id="interstital_facebook_id" value="<?php echo $settings_data['interstital_facebook_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <div class="mb-2 interstital_applovins_id" style="display: none">
                                                            <input type="text" name="interstital_applovins_id" id="interstital_applovins_id" value="<?php echo $settings_data['interstital_applovins_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <div class="mb-2 interstital_wortise_id" style="display: none">
                                                            <input type="text" name="interstital_wortise_id" id="interstital_wortise_id" value="<?php echo $settings_data['interstital_wortise_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <p class="mb-2">Interstitial Ad Clicks</p>
                                                        <div>
                                                            <input type="text" name="interstital_ad_click" id="interstital_ad_click" value="<?php echo $settings_data['interstital_ad_click']; ?>" class="form-control ads_click">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="col-lg-4">
                                            <div class="nsofts-border-card">
                                                <div class="nsofts-border-card__head d-flex align-content-center justify-content-between mb-1">
                                                    <h5 class="mb-0 text-white">Native Ads</h5>
                                                    <div class="nsofts-switch d-flex align-items-center">
                                                        <input type="checkbox" id="checked4" name="native_ad" value="true" class="cbx hidden" <?php if($settings_data['native_ad']=='true'){ echo 'checked'; }?>/>
                                                        <label for="checked4" class="nsofts-switch__label"></label>
                                                    </div>
                                                </div>
                                                <div class="p-3">
                                                    <div class="mb-2">
                                                        <p class="labels" >Native Ad ID</p>
                                                        
                                                        <div class="mb-2 native_ad_id" style="display: none">
                                                            <input type="text" name="native_ad_id" id="native_ad_id" value="<?php echo $settings_data['native_ad_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <div class="mb-2 native_facebook_id" style="display: none">
                                                            <input type="text" name="native_facebook_id" id="native_facebook_id" value="<?php echo $settings_data['native_facebook_id']; ?>" class="form-control">
                                                        </div>
    
                                                        <div class="mb-2 native_applovins_id" style="display: none">
                                                            <input type="text" name="native_applovins_id" id="native_applovins_id" value="<?php echo $settings_data['native_applovins_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <div class="mb-2 native_wortise_id" style="display: none">
                                                            <input type="text" name="native_wortise_id" id="native_wortise_id" value="<?php echo $settings_data['native_wortise_id']; ?>" class="form-control">
                                                        </div>
                                                        
                                                        <p class="mb-1">Position of Ads</p>
                                                        <div class="mb-2">
                                                            <input type="text" name="native_position" id="native_position" value="<?php echo $settings_data['native_position']; ?>" class="form-control ads_click">
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <button type="submit" name="ads_submit" class="btn btn-primary mt-3" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                            <!--Custom ads-->
                            <div class="tab-pane fade" id="nsofts_setting_content_9" role="tabpanel" aria-labelledby="nsofts_setting_9" tabindex="0">
                                <form action="" name="settings_custom" method="POST" enctype="multipart/form-data">
                                    <h4 class="mb-4">Custom ads</h4>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Custom ads</label>
                                        <div class="col-sm-10">
                                            <div class="nsofts-switch d-flex align-items-center">
                                                <input type="checkbox" id="custom_ads" name="custom_ads" value="true" class="cbx hidden" <?php if($settings_data['custom_ads']=='true'){ echo 'checked'; }?>/>
                                                <label for="custom_ads" class="nsofts-switch__label"></label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Image URL</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="custom_ads_img" id="custom_ads_img" value="<?php echo $settings_data['custom_ads_img']; ?>"  class="form-control">
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Ad URL</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="custom_ads_link" id="custom_ads_link" value="<?php echo $settings_data['custom_ads_link']; ?>"   class="form-control">
                                        </div>
                                    </div>
                                    <div class="mb-3 row">
                                        <label for="" class="col-sm-2 col-form-label">Ad Clicks</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="custom_ads_clicks" id="custom_ads_clicks" value="<?php echo $settings_data['custom_ads_clicks']; ?>"   class="form-control">
                                        </div>
                                    </div>
                                    <button type="submit" name="custom_submit" class="btn btn-primary" style="min-width: 120px;">Save</button>
                                </form>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<!-- End: main -->
    
<?php include("includes/footer.php");?>

<script type="text/javascript">
$(document).ready(function(e) {
    var adType = $("select[name='ad_network']").val();
    if (adType === 'admob') {
        $(".publisher_id").show();
        $('.start_ads_id').hide();
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").show();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").show();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").show();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();

        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
        
    } else if (adType === 'facebook') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").show();;
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").show();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").show();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();
        
        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
        
    } else if (adType === 'startapp') {
        $(".publisher_id").hide();
        $('.start_ads_id').show();
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();
        
        $('.labels').hide();
        $('.labels_startapp').show();
        $('.labels_iron').hide();
        
    } else if (adType === 'iron') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').show();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();
        
        $('.labels_iron').show();
        $('.labels').hide();
        $('.labels_startapp').hide();
        
    } else if (adType === 'applovins') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').show();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").show();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").show();
        $(".native_wortise_id").hide();
        
        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
        
    } else if (adType === 'wortise') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').hide();
        $('.wortise_app_id').show();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').show();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").show();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").show();
        
        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
    } 
});

$("select[name='ad_network']").change(function(e) {
    if ($(this).val() === 'admob') {
        $(".publisher_id").show();
        $('.start_ads_id').hide();
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").show();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").show();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").show();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();

        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();

    } else if ($(this).val() === 'facebook') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").show();;
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").show();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").show();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();
        
        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
        
    } else if ($(this).val() === 'startapp') {
        $(".publisher_id").hide();
        $('.start_ads_id').show();
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();
        
        $('.labels').hide();
        $('.labels_startapp').show();
        $('.labels_iron').hide();
        
    } else if ($(this).val() === 'iron') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').show();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").hide();
        
        $('.labels_iron').show();
        $('.labels').hide();
        $('.labels_startapp').hide();
        
    } else if ($(this).val() === 'applovins') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').hide();
        $('.wortise_app_id').hide();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').show();
        $('.banner_wortise_id').hide();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").show();
        $(".interstital_wortise_id").hide();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").show();
        $(".native_wortise_id").hide();
        
        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
        
    } else if ($(this).val() === 'wortise') {
        $(".publisher_id").hide();
        $('.start_ads_id').hide()
        $('.iron_ads_id').hide();
        $('.wortise_app_id').show();
        
        //banner ads
        $(".banner_ad_id").hide();
        $(".banner_facebook_id").hide();
        $('.banner_applovins_id').hide();
        $('.banner_wortise_id').show();
        
        //Interstital ads
        $(".interstital_ad_id").hide();
        $(".interstital_facebook_id").hide();
        $(".interstital_applovins_id").hide();
        $(".interstital_wortise_id").show();
        
        //Native ads
        $(".native_ad_id").hide();
        $(".native_facebook_id").hide();
        $(".native_applovins_id").hide();
        $(".native_wortise_id").show();
        
        $('.labels').show();
        $('.labels_startapp').hide();
        $('.labels_iron').hide();
    }
});

$("input[name='native_position']").blur(function(e) {
    if ($(this).val() == '' || parseInt($(this).val()) <= 0) {
      $(this).val('1');
    }
});

$("#interstital_ad_click").blur(function(e) {
if ($(this).val() == '')
  $(this).val("0");
});

</script>

<script type="text/javascript">

    $(document).ready(function(event) {
        
        $(document).on("click", ".btn_policy", function(e) {
            var el = document.getElementById('clipboard_policy');
            var successful = copyToClipboard(el);
            if (successful) {
                $.notify('Copied!', { position:"top right",className: 'success'} );
            } else {
                $.notify('Whoops, not copied!', { position:"top right",className: 'error'} );
            }
        });
        
        $(document).on("click", ".btn_terms", function(e) {
            var el = document.getElementById('clipboard_terms');
            var successful = copyToClipboard(el);
            if (successful) {
                $.notify('Copied!', { position:"top right",className: 'success'} );
            } else {
                $.notify('Whoops, not copied!', { position:"top right",className: 'error'} );
            }
        });

    });

</script>